var myItem;
var searchIndex;
var drawingImages = new Array();

var Drawing = function(image, label, container)
{
    this.image = image;
    this.label = label;
    this.container = container;
    this.complete = false;
    this.width = 0;
}
Drawing.prototype.isImageComplete = function() { return this.image.complete; }

function showMenu()
{
    $('div#LeftMenu').html("");
	setTimeout("getContent('menu.html','div#LeftMenu','');",100);
	showIndexByNameCode();
}

function setResults(text)
{
    $("div#results").html(text);
}

function search(count)
{
    var txt = document.getElementById("txtSearch")
    if (txt)
    {
        var text = txt.value;
    }
    else
    {
        alert("Unable to locate search box");
    }

    if (text.length < count)
    {
        setResults("<div style='margin-bottom:10px'>invalid search term length</div>");
        return;
    }

    if (!text.match("(^[A-Za-z0-9])"))
    {
        setResults("<div style='margin-bottom:10px'>invalid characters in search term</div>");
        return;
    }

    try
    {
        var regex = new RegExp("(\\d{5};[^\\n]*?" + text + "[^\\n]*)", "gi");
        var matches = searchIndex.match(regex);
        var results = "";
        if (matches)
        {
            var counter = 0;
            for (i = 0; i < matches.length; i++)
            {
                var innerMatches = matches[i].match(/(\d{5});(.*)/);
                if (innerMatches)
                {
                    counter++;
                    inc = innerMatches[1];
                    desc = innerMatches[2];
                    desc = desc.replace(new RegExp(text,"i"), "<span class='bold italic red'>" + text.toUpperCase() + "</span>");
                    results += "<a href='javascript:;' onclick='javascript:s(\"" + inc + "\")'>" + inc + "</a> - " + desc + "<br />";
                }
            }
            results = "<div style='margin-bottom:10px'>" + counter + " items found</div>" + results;
            setResults(results);
        }
        else
        {
            setResults("<div style='margin-bottom:10px'>0 items found</div>");
        }
    }
    catch (e)
    {
        alert("Error in search: " + e);
    }
}

function loadSearch()
{
    $('div#MainContent').html("<div class='center bold centerText'>Please wait, loading index ...</div>");
    $.ajax(
		{
		    url: "index.txt",
		    dataType: "text",
		    success: function(data)
		    {
		        searchIndex = data;
		        window.status = "Search index loaded";
		        getContent("search.html", "div#MainContent");
		        setTimeout("$('input#txtSearch').focus();", 100);
		    },
		    error: function(xhr, textStatus, thrownError)
		    {
		        alert("Searching is disabled.");
		        showIndexByNameCode();
		    }
		}
	);
}


function showPageIndexer() {
    var type = document.getElementById("CURRENTTYPE").value;
    var page = document.getElementById("CURRENTPAGE").value;
    $.ajax(
		{
		    url: type + "_pages.xml",
		    dataType: 'xml',
		    success: function(data)
		    {
		        try
		        {
		            pages = $(data).find("pages")[0].childNodes;
		        }
		        catch (e)
		        {
		            return;
		        }
		        if (pages.length > 0)
		        {
		            var select = "Go To <select size='1' onchange='gotoPage(this)'>";
		            var pageIndex = 0;
		            for (var i = 0; i < pages.length; i++) // page
		            {
		            	if (pages[i].nodeType == 1)
		            	{
		                var start = '';
		                var end = '';

										for (var r=0; r < pages[i].childNodes.length; r++)
										{
											var node = pages[i].childNodes[r];
											if (node.nodeType == 1)
											{
												if (node.nodeName == 'start')
													start = node.textContent;
												else if (node.nodeName == 'end')
													end = node.textContent;
											}
										}
										
		                var patt = new RegExp("([a-zA-Z0-9]| ){3,5}");
		                if (!patt.test(start)) continue;
		                if (!patt.test(end)) continue;

		                if (page == pageIndex)
		                {
		                    select += "<option selected value='" + (pageIndex) + "'>Page " + (pageIndex +1) + ": " + start + " - " + end + "</option>";
		                }
		                else
		                {
		                    select += "<option value='" + (pageIndex) + "'>Page " + (pageIndex +1) + ": " + start + " - " + end + "</option>";
		                }
		            		pageIndex++;
		              }		            
		            }
		            select += "</select>";
		            $('div#pageIndexer').html(select);
		        }
		    },
		    error: function(xhr, ajaxOptions, thrownError)
		    {
		    }
		}
	);
}

function gotoPage(obj) 
{
    var type = document.getElementById("CURRENTTYPE").value;
    document.getElementById("CURRENTPAGE").value = obj.value;
    if (type == "masterlist") 
    {
        showIndexByNameCode("_Page" + obj.value);
    }
    else 
    {
        showIndexByName("_Page" + obj.value);
    }
}

function s(item)
{
    var temp = /^\d{5}$/.exec(item);
    if (temp != null)
    {
        window.open("showItem.html?item=" + item);
        document.forms[0].txtNMCD.value = "";
    }
    else
    {
        alert('Invalid item name code');
    }
}

function showIndexByNameCode(index)
{
	console.log(index);
	searchIndex = "";
	if (index == undefined) index = "_Page0";
	document.getElementById("CURRENTTYPE").value = "masterlist";
	$('div#MainContent').html("<div class='center bold centerText'>Please wait ...</div>");
	setTimeout("getContent('masterlist" + index + ".html','div#MainContent','',showPageIndexer('masterlist'));", 100);
}

function showIndexByName(index)
{
  searchIndex = "";
  if (index == undefined) index = "_Page0";
  document.getElementById("CURRENTTYPE").value = "masterlistbyname";
  $('div#MainContent').html("<div class='center bold centerText'>Please wait ...</div>");
  setTimeout("getContent('masterlistbyname" + index + ".html','div#MainContent','',showPageIndexer('masterlistbyname'));", 100);
}

function setTitle(title)
{
    document.title = $("<div/>").text(title).html();
    $("div#title").text(title);
}

function getItem(page, contentHolderControl, errormsg)
{
    $.ajax(
		{
		    url: page,
		    success: function(data)
		    {
		        // make sure that data is does not contian <script> tags
		        if (data.match(/<script /i) || data.match(/<script>/i))
		        {
		            $(contentHolderControl).html("<div class='center bold centerText'>Invalid content.</div>");
		        }
		        else
		        {
		            try
		            {
		                $(contentHolderControl).html(data);

                        // get page title
		                getPageTitle(myItem + "\\title.xml");

		                // check item for references to ISAC tables
		                var matches = data.match(/LAZY_ISAC_([A-Z]{4})/gim);
		                if (matches != null && matches.length > 0)
		                {
		                    // load content for each referenced isac
		                    for (i = 0; i < matches.length; i++)
		                    {
		                        var mrc = matches[i].match(new RegExp("[A-Z]{4}$"));
		                        var nm = "div#" + matches[i];
		                        var pg = myItem + '\\isac_' + mrc + '.html';
		                        getContent(pg, nm, 'Error loading ISAC Table');
		                    }
		                }

		                // check for supresed content
		                if (document.getElementById("SupressChangeList") != undefined)
		                {
		                    if (document.getElementById("SupressChangeList").value == "true")
		                    {
		                        $("#ChangeListHeader").css("display", "none");
		                    }
		                }

		                // check for drawings
		                var drawingdivs = $("div[id$='_Drawings']");
		                for (i = 0; i < drawingdivs.length; i++)
		                {
		                    var element = drawingdivs[i];
		                    var id = element.id;

		                    getDrawings(id, "Drawings");
		                }

		                // check for reference drawings
		                var refdrawingdivs = $("div[id$='_RefDrawings']");
		                for (i = 0; i < refdrawingdivs.length; i++)
		                {
		                    var element = refdrawingdivs[i];
		                    var id = element.id;

		                    getDrawings(id,"Reference Drawings");
		                }
		            }
		            catch (e)
		            {
		                alert("Error in getItem: " + e);
		            }
		        }
		    },
		    error: function(xhr, ajaxOptions, thrownError)
		    {
		        $(contentHolderControl).html("<div class='center bold centerText'>Error retrieving content: " + ajaxOptions + ".</div>");
		    }
		}
	);
}
function getPageTitle(page) {
    if (!page || page.length == 0) {
        alert("getPageTitle: Missing path");
        return;
    }
    $.ajax(
		{
		    url: page,
		    dataType: 'xml',
		    success: function (data) {
		        var title;
		        try
		        {
		            title = $(data).find("title")[0];
		        }
		        catch (e) {
		            return;
		        }
		        var code = "";
		        var description = "";

						for (var i = 0 ; i < title.childNodes.length; i++)
						{
							var node = title.childNodes[i];
							if (node.nodeType == 1) // element
							{
								if (node.nodeName == 'code')
									code = node.textContent;
								else if (node.nodeName == 'name')
									description = node.textContent;
							}
						}
						
		        if (!/^\d{5}$/.test(code)) return;
		        if (!/^([a-zA-Z0-9]|-|,|;| |~|\(|\)|\.)*$/.test(description)) return;

		        setTitle(code + ' - ' + description);
		    },
		    error: function (xhr, statusText, thrownError) {
		        alert("Error in getPageTitle: " + statusText);
		    }
		}
	);
}

function getDrawings(contentHolderControl, caption)
{
	var container = contentHolderControl.replace("*","");
    var url = myItem + '\\' + container.toLowerCase() + '.xml';

    $.ajax(
		{
		    url: url,
		    dataType: 'xml',
		    error: function(xhr, ajaxOptions, thrownError)
		    {
		    },
		    success: function(data)
		    {
		        if ($('#' + contentHolderControl).length > 0)
		        {
		            try
		            {
		                var drawingContainer = document.createElement("div");
		                var divButtons = document.createElement("div");
		                var expandAnchor = document.createElement("a");
		                var collapseAnchor = document.createElement("a");
		                var expandImage = document.createElement("img");
		                var collapseImage = document.createElement("img");
		                var buttonsSpan = document.createElement("span");
		                var drawings = document.createElement("div");

		                drawingContainer.className = "drawingsContainer";
		                divButtons.style.fontWeight = "bold";
		                expandAnchor.name = expandAnchor.id = "lnkExp" + container;
		                collapseAnchor.name = collapseAnchor.id = "lnkCol" + container;
		                expandAnchor.href = "javascript:expand('lnkExp" + container + "','lnkCol" + container + "','div" + container + "')";
		                collapseAnchor.href = "javascript:collapse('lnkExp" + container + "','lnkCol" + container + "','div" + container + "')";
		                buttonsSpan.className = "buttons";

		                collapseAnchor.style.display = "none";
		                expandAnchor.style.display = "inline";

		                expandImage.src = "images/plus.gif";
		                collapseImage.src = "images/minus.gif";
		                collapseImage.className = expandImage.className = "CollapseButtons";
		                expandImage.setAttribute("alt", "expand");
		                collapseImage.setAttribute("alt", "collapse");
		                expandImage.style.paddingTop = "3px";
		                collapseImage.paddingTop = "3px";


		                drawings.name = drawings.id = "div" + container;
		                drawings.className = "drawings startupState";

		                expandAnchor.appendChild(expandImage);
		                collapseAnchor.appendChild(collapseImage);

		                buttonsSpan.appendChild(expandAnchor);
		                buttonsSpan.appendChild(collapseAnchor);

		                divButtons.appendChild(buttonsSpan);
		                divButtons.appendChild(document.createTextNode(caption));
		                drawingContainer.appendChild(divButtons);
		                var drawingsxml;
		                try
		                {
		                    var drawingsxml = $(data).find("drawings")[0].childNodes;
		                }
		                catch (e)
		                {
		                    return;
		                }
		                if (drawingsxml.length > 0)
		                {
		                    for (var i = 0; i < drawingsxml.length; i++)
		                    {
		                    	if (drawingsxml[i].nodeType == 1)
		                    	{
		                        var id = '';
		                        var height = ''; 
		                        var width = '';

	                    			for (var nodeIndex = 0 ; nodeIndex < drawingsxml[i].childNodes.length; nodeIndex++)
	                    			{
	                    				var node = drawingsxml[i].childNodes[nodeIndex];
	                    				if (node.nodeType == 1)
	                    				{
	                    					if (node.nodeName == 'id')
	            	        						id = node.textContent;
	        	            				else if (node.nodeName == 'height')
	      	              						height = node.textContent;
	  	                  				else if (node.nodeName == 'width')
		                    						width = node.textContent;
	                    				}
		                    		}

		                        if (id.length <= 8)
		                        {
		                            var divContainer = document.createElement("div");
		                            var anchor = document.createElement("a");
		                            var label = document.createElement("div");
		                            var img = new Image();

		                            divContainer.className = "drawing_inline";

		                            img.src = "images/drawings/" + encodeURIComponent(id) + ".png";
		                            img.style.border = "0";
		                            img.setAttribute("alt", id);
		                            if (height > 0 && width > 0)
		                            {
			                            img.setAttribute("height",height);
			                            img.setAttribute("width",width);
			                          }

		                            anchor.href = "images/drawings/" + encodeURIComponent(id) + ".png";
		                            anchor.target = "_blank";
		                            anchor.appendChild(img);
		                            divContainer.appendChild(anchor);
		                            divContainer.appendChild(document.createElement("br"));

		                            label.className = "drawing_label";
		                            label.innerHTML = id;
		                            divContainer.appendChild(label);

		                            drawingImages.push(new Drawing(img, label, divContainer));

		                            drawings.appendChild(divContainer);
		                        }
		                   	 }
		                	}
		              	}
		                setTimeout('alignLabels()', 1000);
		                drawingContainer.appendChild(drawings);
		                document.getElementById(contentHolderControl).appendChild(drawingContainer);
		            }
		            catch (e)
		            {
		                alert(e);
		            }
		        }
		    }
		}
	);
}
function alignLabels()
{
    var i = 0;
    var counter = 0;
    var numOfDrawings = drawingImages.length;
    for (i = 0; i < numOfDrawings; i++)
    {
        var drawing = drawingImages[i];
        var img = drawing.image;
        var label = drawing.label;
        var container = drawing.container;

        if (drawing.isImageComplete())
        {
            label.style.width = (img.width + 20) + "px";
            container.style.width = (img.width + 20) + "px";
            counter++;
        }
    }
    if ((numOfDrawings - counter) > 0) setTimeout('alignLabels()', 1000);
}

function getContent(page, contentHolderControl, errormsg, callback)
{
    $.ajax(
		{
		    url: page,
		    success: function(data)
		    {
		        // make sure that data is does not contian <script> tags
		        if (data.match(/<script /i) || data.match(/<script>/i))
		        {
		            $(contentHolderControl).html("<div class='center bold centerText'>Content invalid.</div>");
		        }
		        else
		        {
		            if ($(contentHolderControl).length > 0)
		            {
		                $(contentHolderControl).html("<div class='center bold centerText'>Loading content, please wait...</div>");
		                $(contentHolderControl).html(data);
		            }
		            if ($('#pageIndexer').length) showPageIndexer();
		            if (callback) callback();
		        }
		    },
		    error: function(xhr, ajaxOptions, thrownError)
		    {
		        $(contentHolderControl).html("<div class='center bold centerText'>Error retrieving content.</div>");
		    }
		}
	);
}

function showMRC(mrc)
{
    getContent(mrc + '.html', 'div#MainContent', 'Unable to find MRC content.');
	window.scrollTo(0,0);
}

function setup()
{
	showMenu();
}

function showItem()
{
	var regex = /\?item=(\d{5})/i;
    if (regex.exec(document.location.search))
    {
        myItem = regex.exec(document.location.search)[1];
    }

    if (myItem && /^\d{5}$/.test(myItem))
    {
        getContent(myItem + '/menu.html', 'div#LeftMenu', 'Unable to find menu content');
        $('div#MainContent').html("<div class='center bold centerText'>Please wait ...</div>");

        getItem(myItem + '/item.html','div#MainContent','Unable to find Item content');
    }
    else
    {
        $('div#MainContent').html("<div class='center bold centerText'>Error loading content</div>");
    }
    
    // get window size
    resize();

    //setup resize event
    $(window).resize(function() { setTimeout("resize();", 100); });
}


function collapse(imgOpen, imgClose, divContainer)
{
    $("body").css("cursor", "wait");

    var open = document.getElementById(imgOpen);
    var close = document.getElementById(imgClose);
    var container = document.getElementById(divContainer);

    container.style.display = "none";
    open.style.display = "inline";
    close.style.display = "none";
    
    $("body").css("cursor", "default");
}

function expand(imgOpen,imgClose,divContainer)
{
    $("body").css("cursor", "wait");
    
    var open = document.getElementById(imgOpen);
    var close = document.getElementById(imgClose);
    var container = document.getElementById(divContainer);

    container.style.display = "block";
    open.style.display = "none";
    close.style.display = "inline";
    
    $("body").css("cursor", "default");
}

function resize()
{
    var winHeight = $(window).height() - 6;
    $('div#LeftMenu').css('height', winHeight + 'px');
    $('div#MainContent').css('height', winHeight + 'px');
}
